﻿using System;
using Soneta.Business;
using Soneta.Ksiega;
using Soneta.Types;
using Soneta.Web;

namespace ASP {
    public partial class Ewidencja_Przychodow_Szeroki : System.Web.UI.Page {
        public string Str_SumaMiesiaca = "<strong>Suma miesiąca:</strong>";
        public string Str_Przeniesienie = "<strong>Przeniesienie z poprzednich miesięcy:</strong>";
        public string Str_Razem = "<strong>Razem od początku roku:</strong>";

        //----------
        public class Params : ContextBase {

            public Params(Context context) : base(context) {
                miesiąc = new YearMonth(Date.Today);
            }

            YearMonth miesiąc;
            [Required]
            [Caption("Wydruk za miesiąc")]
            public YearMonth Miesiąc {
                get { return miesiąc; }
                set {
                    miesiąc = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }

        Params pars;
        [Context]
        public Params Pars {
            get { return pars; }
            set { pars = value; }
        }

        FromTo miesiąc;
        decimal[] przeniesienie = new decimal[7];
        KPiR.KPiRWorker worker = new KPiR.KPiRWorker();

        protected void dc_ContextLoad(Object sender, EventArgs e) {
            ReportHeader["OKRES"] = Pars.Miesiąc.ToString();
            miesiąc = Pars.Miesiąc.ToFromTo();
            OkresObrachunkowy okres = (OkresObrachunkowy)dc[typeof(OkresObrachunkowy)];
            KsiegaModule ksiega = KsiegaModule.GetInstance(dc);

            Date data = miesiąc.To;
            kwota05.Caption = kwota05.Caption.Replace("S1", ksiega.Config.Ryczałt.Stawka1[data].ToString());
            kwota06.Caption = kwota06.Caption.Replace("S2", ksiega.Config.Ryczałt.Stawka2[data].ToString());
            kwota07.Caption = kwota07.Caption.Replace("S3", ksiega.Config.Ryczałt.Stawka3[data].ToString());
            kwota08.Caption = kwota08.Caption.Replace("S4", ksiega.Config.Ryczałt.Stawka4[data].ToString());
            kwota09.Caption = kwota09.Caption.Replace("S5", ksiega.Config.Ryczałt.Stawka5[data].ToString());
            kwota10.Caption = kwota10.Caption.Replace("S6", ksiega.Config.Ryczałt.Stawka6[data].ToString());

            kwotaS05.Caption = kwota05.Caption;
            kwotaS06.Caption = kwota06.Caption;
            kwotaS07.Caption = kwota07.Caption;
            kwotaS08.Caption = kwota08.Caption;
            kwotaS09.Caption = kwota09.Caption;
            kwotaS10.Caption = kwota10.Caption;

            Soneta.Business.View view = ksiega.Dziennik.WgKPiR.CreateView();
            view.Condition &= new FieldCondition.Equal("Okres", okres);
            view.Condition &= "KPiR.Lp>0";
            Grid.DataSource = view;

            Grid1.DataSource = new object[] { 1, 2, 3 };
        }

        protected void Grid_BeforeRow(Object sender, RowEventArgs args) {
            DekretBase dekret = (DekretBase)args.Row;
            bool sum = dekret.KPiR.Stan != StanyZapisuKPiR.Przekreślony;
            if (dekret.Data < miesiąc.From) {
                args.VisibleRow = false;
                if (sum) {
                    worker.Dekret = dekret;
                    przeniesienie[0] += worker.R1.Value;
                    przeniesienie[1] += worker.R2.Value;
                    przeniesienie[2] += worker.R3.Value;
                    przeniesienie[3] += worker.R4.Value;
                    przeniesienie[4] += worker.R5.Value;
                    przeniesienie[5] += worker.R6.Value;
                    przeniesienie[6] += worker.RyczaltRazem.Value;
                }
            }
            else if (dekret.Data > miesiąc.To)
                args.VisibleRow = false;
            else {
                worker.Dekret = dekret;
                SetCol(kwota05, worker.R1.Value, sum);
                SetCol(kwota06, worker.R2.Value, sum);
                SetCol(kwota07, worker.R3.Value, sum);
                SetCol(kwota08, worker.R4.Value, sum);
                SetCol(kwota09, worker.R5.Value, sum);
                SetCol(kwota10, worker.R6.Value, sum);
                SetCol(kwota11, worker.RyczaltRazem.Value, sum);
            }
        }

        protected void Grid1_BeforeRow(Object sender, RowEventArgs args) {
            int n = (int)args.Row;
            switch (n) {
                case 1:
                    kwotaS05.EditValue = ObjToDec(kwota05.TotalValue);
                    kwotaS06.EditValue = ObjToDec(kwota06.TotalValue);
                    kwotaS07.EditValue = ObjToDec(kwota07.TotalValue);
                    kwotaS08.EditValue = ObjToDec(kwota08.TotalValue);
                    kwotaS09.EditValue = ObjToDec(kwota09.TotalValue);
                    kwotaS10.EditValue = ObjToDec(kwota10.TotalValue);
                    kwotaS11.EditValue = ObjToDec(kwota11.TotalValue);
                    kwotaSInfo.EditValue = Str_SumaMiesiaca;
                    break;
                case 2:
                    kwotaS05.EditValue = przeniesienie[0];
                    kwotaS06.EditValue = przeniesienie[1];
                    kwotaS07.EditValue = przeniesienie[2];
                    kwotaS08.EditValue = przeniesienie[3];
                    kwotaS09.EditValue = przeniesienie[4];
                    kwotaS10.EditValue = przeniesienie[5];
                    kwotaS11.EditValue = przeniesienie[6];
                    kwotaSInfo.EditValue = Str_Przeniesienie;
                    break;
                case 3:
                    kwotaS05.EditValue = przeniesienie[0] + ObjToDec(kwota05.TotalValue);
                    kwotaS06.EditValue = przeniesienie[1] + ObjToDec(kwota06.TotalValue);
                    kwotaS07.EditValue = przeniesienie[2] + ObjToDec(kwota07.TotalValue);
                    kwotaS08.EditValue = przeniesienie[3] + ObjToDec(kwota08.TotalValue);
                    kwotaS09.EditValue = przeniesienie[4] + ObjToDec(kwota09.TotalValue);
                    kwotaS10.EditValue = przeniesienie[5] + ObjToDec(kwota10.TotalValue);
                    kwotaS11.EditValue = przeniesienie[6] + ObjToDec(kwota11.TotalValue);
                    kwotaSInfo.EditValue = Str_Razem;
                    break;
            }
        }

        void SetCol(Soneta.Web.GridColumn col, decimal value, bool sum) {
            col.SumRow = sum;
            if (sum || value != 0) {
                col.Format = "{0:n}";
                col.EditValue = value;
            }
            else
                col.Format = "<center>-------------</center>";
        }

        decimal ObjToDec(object value) {
            return value == null ? 0m : (decimal)value;
        }

        void Msg(object obj) {
        }
    }
}
